/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.plugin.analysis.ik.AnalysisIkPlugin;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.dic.DictSegment;
import org.wltea.analyzer.dic.Hit;
import org.wltea.analyzer.dic.Monitor;
import org.wltea.analyzer.help.ESPluginLoggerFactory;

public class Dictionary {
    private static Dictionary singleton;
    private DictSegment _MainDict;
    private DictSegment _QuantifierDict;
    private DictSegment _StopWords;
    private Configuration configuration;
    private static final Logger logger;
    private static ScheduledExecutorService pool;
    private static final String PATH_DIC_MAIN = "main.dic";
    private static final String PATH_DIC_SURNAME = "surname.dic";
    private static final String PATH_DIC_QUANTIFIER = "quantifier.dic";
    private static final String PATH_DIC_SUFFIX = "suffix.dic";
    private static final String PATH_DIC_PREP = "preposition.dic";
    private static final String PATH_DIC_STOP = "stopword.dic";
    private static final String FILE_NAME = "IKAnalyzer.cfg.xml";
    private static final String EXT_DICT = "ext_dict";
    private static final String REMOTE_EXT_DICT = "remote_ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private static final String REMOTE_EXT_STOP = "remote_ext_stopwords";
    private Path conf_dir;
    private Properties props;

    private Dictionary(Configuration cfg) {
        this.configuration = cfg;
        this.props = new Properties();
        this.conf_dir = cfg.getEnvironment().configFile().resolve(AnalysisIkPlugin.PLUGIN_NAME);
        Path configFile = this.conf_dir.resolve(FILE_NAME);
        FileInputStream input = null;
        try {
            logger.info("try load config from {}", new Object[]{configFile});
            input = new FileInputStream(configFile.toFile());
        }
        catch (FileNotFoundException e) {
            this.conf_dir = cfg.getConfigInPluginDir();
            configFile = this.conf_dir.resolve(FILE_NAME);
            try {
                logger.info("try load config from {}", new Object[]{configFile});
                input = new FileInputStream(configFile.toFile());
            }
            catch (FileNotFoundException ex) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (IOException e) {
                logger.error("ik-analyzer", (Throwable)e);
            }
        }
    }

    private String getProperty(String key) {
        if (this.props != null) {
            return this.props.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initial(Configuration cfg) {
        if (singleton != null) return;
        Class<Dictionary> clazz = Dictionary.class;
        synchronized (Dictionary.class) {
            if (singleton != null) return;
            singleton = new Dictionary(cfg);
            singleton.loadMainDict();
            singleton.loadSurnameDict();
            singleton.loadQuantifierDict();
            singleton.loadSuffixDict();
            singleton.loadPrepDict();
            singleton.loadStopWordDict();
            if (!cfg.isEnableRemoteDict()) return;
            for (String location : singleton.getRemoteExtDictionarys()) {
                pool.scheduleAtFixedRate(new Monitor(location), 10L, 60L, TimeUnit.SECONDS);
            }
            for (String location : singleton.getRemoteExtStopWordDictionarys()) {
                pool.scheduleAtFixedRate(new Monitor(location), 10L, 60L, TimeUnit.SECONDS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void walkFileTree(final List<String> files, Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            files.add(path.toString());
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        files.add(file.toString());
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException e) {
                        logger.error("[Ext Loading] listing files", (Throwable)e);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                logger.error("[Ext Loading] listing files", (Throwable)e);
            }
        } else {
            logger.warn("[Ext Loading] file not found: " + path);
        }
    }

    private void loadDictFile(DictSegment dict, Path file, boolean critical, String name) {
        try (FileInputStream is = new FileInputStream(file.toFile());){
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 512);
            String word = br.readLine();
            if (word != null) {
                if (word.startsWith("\ufeff")) {
                    word = word.substring(1);
                }
                while (word != null) {
                    if (!(word = word.trim()).isEmpty()) {
                        dict.fillSegment(word.toCharArray());
                    }
                    word = br.readLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("ik-analyzer: " + name + " not found", (Throwable)e);
            if (critical) {
                throw new RuntimeException("ik-analyzer: " + name + " not found!!!", e);
            }
        }
        catch (IOException e) {
            logger.error("ik-analyzer: " + name + " loading failed", (Throwable)e);
        }
    }

    private List<String> getExtDictionarys() {
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = this.getProperty(EXT_DICT);
        if (extDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = extDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{filePath.trim()});
                this.walkFileTree(extDictFiles, file);
            }
        }
        return extDictFiles;
    }

    private List<String> getRemoteExtDictionarys() {
        ArrayList<String> remoteExtDictFiles = new ArrayList<String>(2);
        String remoteExtDictCfg = this.getProperty(REMOTE_EXT_DICT);
        if (remoteExtDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = remoteExtDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                remoteExtDictFiles.add(filePath);
            }
        }
        return remoteExtDictFiles;
    }

    private List<String> getExtStopWordDictionarys() {
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = this.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = extStopWordDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{filePath.trim()});
                this.walkFileTree(extStopWordDictFiles, file);
            }
        }
        return extStopWordDictFiles;
    }

    private List<String> getRemoteExtStopWordDictionarys() {
        ArrayList<String> remoteExtStopWordDictFiles = new ArrayList<String>(2);
        String remoteExtStopWordDictCfg = this.getProperty(REMOTE_EXT_STOP);
        if (remoteExtStopWordDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = remoteExtStopWordDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                remoteExtStopWordDictFiles.add(filePath);
            }
        }
        return remoteExtStopWordDictFiles;
    }

    private String getDictRoot() {
        return this.conf_dir.toAbsolutePath().toString();
    }

    public static Dictionary getSingleton() {
        if (singleton == null) {
            throw new IllegalStateException("ik dict has not been initialized yet, please call initial method first.");
        }
        return singleton;
    }

    public void addWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.fillSegment(word.trim().toCharArray());
            }
        }
    }

    public void disableWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.disableSegment(word.trim().toCharArray());
            }
        }
    }

    public Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWords.match(charArray, begin, length).isMatch();
    }

    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_MAIN});
        this.loadDictFile(this._MainDict, file, false, "Main Dict");
        this.loadExtDict();
        this.loadRemoteExtDict();
    }

    private void loadExtDict() {
        List<String> extDictFiles = this.getExtDictionarys();
        if (extDictFiles != null) {
            for (String extDictName : extDictFiles) {
                logger.info("[Dict Loading] " + extDictName);
                Path file = PathUtils.get((String)extDictName, (String[])new String[0]);
                this.loadDictFile(this._MainDict, file, false, "Extra Dict");
            }
        }
    }

    private void loadRemoteExtDict() {
        List<String> remoteExtDictFiles = this.getRemoteExtDictionarys();
        for (String location : remoteExtDictFiles) {
            logger.info("[Dict Loading] " + location);
            List<String> lists = Dictionary.getRemoteWords(location);
            if (lists == null) {
                logger.error("[Dict Loading] " + location + " load failed");
                continue;
            }
            for (String theWord : lists) {
                if (theWord == null || "".equals(theWord.trim())) continue;
                logger.info(theWord);
                this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            }
        }
    }

    private static List<String> getRemoteWords(String location) {
        SpecialPermission.check();
        return AccessController.doPrivileged(() -> Dictionary.getRemoteWordsUnprivileged(location));
    }

    private static List<String> getRemoteWordsUnprivileged(String location) {
        ArrayList<String> buffer = new ArrayList<String>();
        RequestConfig rc = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(60000).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet get = new HttpGet(location);
        get.setConfig(rc);
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                String charset = "UTF-8";
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String typeValue;
                    Header contentType = entity.getContentType();
                    if (contentType != null && contentType.getValue() != null && (typeValue = contentType.getValue()) != null && typeValue.contains("charset=")) {
                        charset = typeValue.substring(typeValue.lastIndexOf("=") + 1);
                    }
                    if (entity.getContentLength() > 0L || entity.isChunked()) {
                        String line;
                        BufferedReader in = new BufferedReader(new InputStreamReader(entity.getContent(), charset));
                        while ((line = in.readLine()) != null) {
                            buffer.add(line);
                        }
                        in.close();
                        response.close();
                        return buffer;
                    }
                }
            }
            response.close();
        }
        catch (IOException | IllegalStateException e) {
            logger.error("getRemoteWords {} error", new Object[]{e, location});
        }
        return buffer;
    }

    private void loadStopWordDict() {
        this._StopWords = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_STOP});
        this.loadDictFile(this._StopWords, file, false, "Main Stopwords");
        List<String> extStopWordDictFiles = this.getExtStopWordDictionarys();
        if (extStopWordDictFiles != null) {
            for (String extStopWordDictName : extStopWordDictFiles) {
                logger.info("[Dict Loading] " + extStopWordDictName);
                file = PathUtils.get((String)extStopWordDictName, (String[])new String[0]);
                this.loadDictFile(this._StopWords, file, false, "Extra Stopwords");
            }
        }
        List<String> remoteExtStopWordDictFiles = this.getRemoteExtStopWordDictionarys();
        for (String location : remoteExtStopWordDictFiles) {
            logger.info("[Dict Loading] " + location);
            List<String> lists = Dictionary.getRemoteWords(location);
            if (lists == null) {
                logger.error("[Dict Loading] " + location + " load failed");
                continue;
            }
            for (String theWord : lists) {
                if (theWord == null || "".equals(theWord.trim())) continue;
                logger.info(theWord);
                this._StopWords.fillSegment(theWord.trim().toLowerCase().toCharArray());
            }
        }
    }

    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_QUANTIFIER});
        this.loadDictFile(this._QuantifierDict, file, false, "Quantifier");
    }

    private void loadSurnameDict() {
        DictSegment _SurnameDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_SURNAME});
        this.loadDictFile(_SurnameDict, file, true, "Surname");
    }

    private void loadSuffixDict() {
        DictSegment _SuffixDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_SUFFIX});
        this.loadDictFile(_SuffixDict, file, true, "Suffix");
    }

    private void loadPrepDict() {
        DictSegment _PrepDict = new DictSegment(Character.valueOf('\u0000'));
        Path file = PathUtils.get((String)this.getDictRoot(), (String[])new String[]{PATH_DIC_PREP});
        this.loadDictFile(_PrepDict, file, true, "Preposition");
    }

    void reLoadMainDict() {
        logger.info("start to reload ik dict.");
        Dictionary tmpDict = new Dictionary(this.configuration);
        tmpDict.configuration = Dictionary.getSingleton().configuration;
        tmpDict.loadMainDict();
        tmpDict.loadStopWordDict();
        this._MainDict = tmpDict._MainDict;
        this._StopWords = tmpDict._StopWords;
        logger.info("reload ik dict finished.");
    }

    static {
        logger = ESPluginLoggerFactory.getLogger(Dictionary.class.getName());
        pool = Executors.newScheduledThreadPool(1);
    }
}

